/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3966;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class InsatibleModifier
extends Modifier
implements ProjectileHitModifierHook,
ConditionalStatModifierHook {
    private static float getBonus(class_1309 attacker, int level, TinkerEffect effect) {
        int effectLevel = effect.getLevel(attacker) + 1;
        return (float)(level * effectLevel) / 4.0f;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.PROJECTILE_HIT, TinkerHooks.CONDITIONAL_STAT);
    }

    @Override
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage + InsatibleModifier.getBonus(context.getAttacker(), level, (TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get())) * tool.getMultiplier(ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && context.isFullyCharged()) {
            class_1309 attacker = context.getAttacker();
            int effectLevel = Math.min(7, ((TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get())).getLevel(attacker) + 1);
            ((TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get())).apply(attacker, 100, effectLevel, true);
        }
        return 0;
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, class_1309 living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.PROJECTILE_DAMAGE) {
            baseValue += InsatibleModifier.getBonus(living, modifier.getLevel(), (TinkerEffect)((Object)TinkerModifiers.insatiableRangedEffect.get())) / 2.0f * multiplier;
        }
        return baseValue;
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, class_1676 projectile, class_3966 hit, @Nullable class_1309 attacker, @Nullable class_1309 target) {
        if (attacker != null) {
            int effectLevel = Math.min(7, ((TinkerEffect)((Object)TinkerModifiers.insatiableRangedEffect.get())).getLevel(attacker) + 1);
            ((TinkerEffect)((Object)TinkerModifiers.insatiableRangedEffect.get())).apply(attacker, 200, effectLevel, true);
        }
        return false;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 flag) {
        float bonus = level * 2;
        if (player != null && key == TooltipKey.SHIFT) {
            bonus = InsatibleModifier.getBonus((class_1309)player, level, tool.hasTag(TinkerTags.Items.RANGED) ? (TinkerEffect)((Object)TinkerModifiers.insatiableRangedEffect.get()) : (TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get()));
        }
        this.addDamageTooltip(tool, bonus, tooltip);
    }
}

